from PIL import Image

# Read the SAT assignments from the text file
with open('Samples_25_50_10_0_.txt', 'r') as file:
    sat_assignments = file.readlines()

# Process each SAT assignment
for index, assignment in enumerate(sat_assignments):
    # Split the assignment into variables
    variables = assignment.strip().split()[:25]

    # Create a blank 5x5 image
    image = Image.new('1', (5, 5))

    # Set the pixel values based on the variables
    for i, variable in enumerate(variables):
        x = int(variable)
        pixel_value = 1 if x > 0 else 0
        image.putpixel((i % 5, i // 5), pixel_value)

    # Save the image
    image.save(f'image{index+1}.png')